<?php
/**
 * Editorial: Show Video
 *
 * Widget to show single video iframe at any widget area.
 *
 * @package Mystery Themes
 * @subpackage Editorial Pro
 * @since 1.0.0
 */

add_action( 'widgets_init', 'editorial_pro_register_show_video_widget' );

function editorial_pro_register_show_video_widget() {
    register_widget( 'Editorial_Pro_Show_Video' );
}

class Editorial_Pro_Show_Video extends WP_Widget {

	/**
     * Register widget with WordPress.
     */
    public function __construct() {
        $widget_ops = array( 
            'classname' => 'editorial_pro_show_video',
            'description' => __( 'Show the single video iframe using video url from vimeo and youtube..', 'editorial-pro' )
        );
        parent::__construct( 'editorial_pro_show_video', __( 'Editorial: Show Video', 'editorial-pro' ), $widget_ops );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {

        $fields = array(

            'editorial_pro_block_title' => array(
                'editorial_pro_widgets_name'         => 'editorial_pro_block_title',
                'editorial_pro_widgets_title'        => __( 'Video Title', 'editorial-pro' ),
                'editorial_pro_widgets_field_type'   => 'text'
            ),

            'editorial_pro_block_video_url' => array(
                'editorial_pro_widgets_name' => 'editorial_pro_block_video_url',
                'editorial_pro_widgets_title' => __( 'Add video url', 'editorial-pro' ),
                'editorial_pro_widgets_field_type' => 'url'
            )
        );
        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        extract( $args );
        if( empty( $instance ) ) {
            return ;
        }

        $editorial_pro_block_title       = empty( $instance['editorial_pro_block_title'] ) ? '' : $instance['editorial_pro_block_title'];
        $editorial_pro_block_video_url   = empty( $instance['editorial_pro_block_video_url'] ) ? '' : $instance['editorial_pro_block_video_url'];

        echo $before_widget;
    ?>
        <div class="show-video-wrapper fitvids-video clearfix">
            <div class="block-header">
                <h3 class="block-title"><?php echo esc_html( $editorial_pro_block_title ); ?></h3>
            </div><!-- .block-header -->
            <div class="video-wrap">
                <?php echo wp_oembed_get( $editorial_pro_block_video_url ); ?>
            </div><!-- .video-wrap -->
        </div><!-- .show-video-wrapper -->

    <?php
        echo $after_widget;
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param   array   $new_instance   Values just sent to be saved.
     * @param   array   $old_instance   Previously saved values from database.
     *
     * @uses    editorial_pro_widgets_updated_field_value()     defined in editorial-widget-fields.php
     *
     * @return  array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            extract( $widget_field );

            // Use helper function to get updated field values
            $instance[$editorial_pro_widgets_name] = editorial_pro_widgets_updated_field_value( $widget_field, $new_instance[$editorial_pro_widgets_name] );
        }

        return $instance;
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param   array $instance Previously saved values from database.
     *
     * @uses    editorial_pro_widgets_show_widget_field()       defined in widget-fields.php
     */
    public function form( $instance ) {
        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            // Make array elements available as variables
            extract( $widget_field );
            $editorial_pro_widgets_field_value = !empty( $instance[$editorial_pro_widgets_name] ) ? wp_kses_post( $instance[$editorial_pro_widgets_name] ) : '';
            editorial_pro_widgets_show_widget_field( $this, $widget_field, $editorial_pro_widgets_field_value );
        }
    }

}